/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.mmparser;

/**
 * A part is an abstract upload part which represents an input form element in a
 * <code>multipart/form-data</code> form submission.
 *
 * @author SAP AG
 * @see FilePart
 * @see ParamPart
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/api/com/sapportals/wcm/util/mmparser/AbstractPart.java#5
 *      $ Copyright (c) SAP AG 2001-2002
 */
public abstract class AbstractPart {
  /**
   * <Please write something about this attribute>
   *
   *
   */
  private String name;

  /**
   * Constructs an upload part with the given name.
   *
   * @param name <Please write something about this parameter>
   *
   *
   */
  AbstractPart(String name) {
    this.name = name;
  }

  /**
   * Returns the name of the form element that this Part corresponds to.
   *
   * @return the name of the form element that this Part corresponds to.
   */
  public String getName() {
    return name;
  }

  /**
   * Returns true if this Part is a FilePart.
   *
   * @return true if this is a FilePart.
   */
  public boolean isFile() {
    return false;
  }
}

