/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.log;

/**
 * TBD: Description of the interface.
 */
public interface ICategory {
  public final static int LEVEL_ALL = 0xffffffff;
  public final static int LEVEL_FATAL = 1;
  public final static int LEVEL_ERROR = 2;
  public final static int LEVEL_WARN = 4;
  public final static int LEVEL_INFO = 8;
  public final static int LEVEL_DEBUG = 16;

  public void setLogMask(int mask);

  public void fatal(Object message);

  public void fatal(Object message, Throwable throwable);

  public void error(Object message);

  public void errorStack(Object message);

  public void error(Object message, Throwable throwable);

  public void warn(Object message);

  public void warn(Object message, Throwable throwable);

  public void info(Object message);

  public void info(Object message, Throwable throwable);

  public void debug(Object message);

  public void debugStack(Object message);

  public void debug(Object message, Throwable throwable);

  void assertNotNull(final Object message, final Object test);

  void assertTrue(final Object message, final boolean test);

  public boolean isFatalEnabled();

  public boolean isErrorEnabled();

  public boolean isWarnEnabled();

  public boolean isInfoEnabled();

  public boolean isDebugEnabled();
}
