/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.log;

/**
 * Channel for writing log output to the console
 */
public class ConsoleChannel extends AbstractChannel implements IChannel {

  public ConsoleChannel(String fileName, Long maxSize, Integer maxBacklog, Boolean showStackTraces, Boolean showThreads)
    throws Exception {
    super(maxSize, maxBacklog, showStackTraces, showThreads);
  }

  public void log(String method, int level, Object message, Throwable throwable) {
    System.out.print(getLogText(method, level, message, throwable));
  }
}
