/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.log;

import com.sap.tc.logging.*;
import com.sapportals.wcm.util.logging.*;

import java.util.*;

/**
 * Class wrapping a standard logging location.
 *
 * @author Vedran Lerenc
 * @deprecated as of NW04. Please use the standard logging instead.
 */
public class Category implements ICategory {
  private Location location;
  private final static String fallbackName =
    "com.sap.wcm.IllegallyNamedLocationOrCategory";
  private final static Category fallbackCategory = new Category(fallbackName);
  private final static Map instances = new WeakHashMap();

  /**
   * Construct object of class Category.
   *
   * @param module
   * @todo: Description of the incoming method parameter
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  private Category(String module) {
    module = module.replace(' ', '_').replace('/', '_').replace('\\', '_');
    if (!module.startsWith("com.")) {
      module = fallbackName + "." + module;
    }
    location = Location.getLocation(module);
  }

  /**
   * Get name of internal location.
   *
   * @return name of internal location
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public String getName() {
    return location.getName();
  }

  /**
   * Get the FatalEnabled attribute of the Category object.
   *
   * @return The FatalEnabled value
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public final boolean isFatalEnabled() {
    return location.beFatal();
  }

  /**
   * Get the ErrorEnabled attribute of the Category object.
   *
   * @return The ErrorEnabled value
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public final boolean isErrorEnabled() {
    return location.beError();
  }

  /**
   * Get the WarnEnabled attribute of the Category object.
   *
   * @return The WarnEnabled value
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public final boolean isWarnEnabled() {
    return location.beWarning();
  }

  /**
   * Get the InfoEnabled attribute of the Category object.
   *
   * @return The InfoEnabled value
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public final boolean isInfoEnabled() {
    return location.beInfo();
  }

  /**
   * Get the DebugEnabled attribute of the Category object.
   *
   * @return The DebugEnabled value
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public final boolean isDebugEnabled() {
    return location.beDebug();
  }

  /**
   * @param message
   * @todo: Description of the Method.
   * @todo: Description of the incoming method parameter
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public final void fatal(Object message) {
    direct(ICategory.LEVEL_FATAL, message, null);
  }

  /**
   * @param message
   * @param throwable
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public final void fatal(Object message, Throwable throwable) {
    direct(ICategory.LEVEL_FATAL, message, throwable);
  }

  /**
   * @param message
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public final void error(Object message) {
    direct(ICategory.LEVEL_ERROR, message, null);
  }

  /**
   * @param message
   * @param throwable
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public final void error(Object message, Throwable throwable) {
    direct(ICategory.LEVEL_ERROR, message, throwable);
  }

  /**
   * @param message
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public final void errorStack(Object message) {
    final String EXCEPTION_TEXT = "stack";
    try {
      throw new Exception(EXCEPTION_TEXT);
    }
    catch (Exception e) {
      direct(ICategory.LEVEL_ERROR, message, e);
    }
  }

  /**
   * @param message
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public void warn(Object message) {
    direct(ICategory.LEVEL_WARN, message, null);
  }

  /**
   * @param message
   * @param throwable
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public void warn(Object message, Throwable throwable) {
    direct(ICategory.LEVEL_WARN, message, throwable);
  }

  /**
   * @param message
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public final void info(Object message) {
    direct(ICategory.LEVEL_INFO, message, null);
  }

  /**
   * @param message
   * @param throwable
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public void info(Object message, Throwable throwable) {
    direct(ICategory.LEVEL_INFO, message, throwable);
  }

  /**
   * @param message
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public void debug(Object message) {
    direct(ICategory.LEVEL_DEBUG, message, null);
  }

  /**
   * @param message
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public void debugStack(Object message) {
    final String EXCEPTION_TEXT = "stack";
    try {
      throw new Exception(EXCEPTION_TEXT);
    }
    catch (Exception e) {
      direct(ICategory.LEVEL_DEBUG, message, e);
    }
  }

  /**
   * @param message
   * @param throwable
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public final void debug(Object message, Throwable throwable) {
    direct(ICategory.LEVEL_DEBUG, message, throwable);
  }

  /**
   * Asserts that an object isn't null. Otherwise an error message will be
   * printed.
   *
   * @param message TBD: Description of the incoming method parameter
   * @param test TBD: Description of the incoming method parameter
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public final void assertNotNull(final Object message, final Object test) {
    if (null == test) {
      debug(message);
    }
  }

  /**
   * Asserts that a boolean isn't false. Otherwise an error message will be
   * printed.
   *
   * @param message TBD: Description of the incoming method parameter
   * @param test TBD: Description of the incoming method parameter
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public final void assertTrue(final Object message, final boolean test) {
    if (false == test) {
      debug(message);
    }
  }

  /**
   * Set the LogMask attribute of the Category object. This methid call will be
   * ignored!
   *
   * @param mask The new LogMask value
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public final void setLogMask(int mask) {
    // Ignore
    ;
  }

  /**
   * Set the DefaultLogMask attribute of the Category class. This methid call
   * will be ignored!
   *
   * @param mask The new DefaultLogMask value
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public final static synchronized void setDefaultLogMask(int mask) {
    // Ignore
    ;
  }

  /**
   * Set the DefaultLogMask attribute of the Category class. This methid call
   * will be ignored!
   *
   * @param module defaultLogMask to be set
   * @param mask defaultLogMask to be set
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public final static synchronized void setDefaultLogMask(
    String module,
    int mask) {
    // Ignore
    ;
  }

  /**
   * Set the LogDirectory attribute of the Category class. This methid call will
   * be ignored!
   *
   * @param directory logDirectory to be set
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public final static synchronized void setLogDirectory(String directory) {
    // Ignore
    ;
  }

  /**
   * Set the AllLogMasks attribute of the Category class. This methid call will
   * be ignored!
   *
   * @param mask allLogMasks to be set
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public final static synchronized void setAllLogMasks(int mask) {
    // Ignore
    ;
  }

  /**
   * Get the Instance attribute of the Category class.
   *
   * @param module TBD: Description of the incoming method parameter
   * @return instance
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public final static synchronized Category getInstance(String module) {
    Category category = (Category)instances.get(module);
    if (category == null) {
      try {
        instances.put(module, category = new Category(module));
      }
      catch (Throwable throwable) {
            //$JL-EXC$
        category = fallbackCategory;
      }
    }
    return category;
  }

  /**
   * Get the Instance attribute of the Category class.
   *
   * @param module TBD: Description of the incoming method parameter
   * @return instance
   * @deprecated as of NW04. Please use the standard logging instead.
   */
  public final static Category getInstance(Class module) {
    return getInstance(module.getName());
  }

  private synchronized void direct(
    int level,
    Object message,
    Throwable throwable) {
    // Determine severity
    int sev;
    switch (level) {
      case ICategory.LEVEL_FATAL:
        sev = Severity.FATAL;
        break;
      case ICategory.LEVEL_ERROR:
        sev = Severity.ERROR;
        break;
      case ICategory.LEVEL_WARN:
        sev = Severity.WARNING;
        break;
      case ICategory.LEVEL_INFO:
        sev = Severity.INFO;
        break;
      case ICategory.LEVEL_DEBUG:
        sev = Severity.DEBUG;
        break;
      default:
        sev = Severity.ALL;
    }

    // Log message
    if (throwable != null) {
      location.logT(
        sev,
        message.toString()
         + LoggingFormatter.extractCallstack(throwable));
    }
    else {
      location.logT(sev, message.toString());
    }
  }
}
