/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.http.slim;

import com.sapportals.wcm.util.http.Headers;
import com.sapportals.wcm.util.http.HttpStatus;
import com.sapportals.wcm.util.http.IResponse;
import java.io.InputStream;

import java.util.*;

import org.w3c.dom.Document;

/**
 * Implementation of IWDResponse for http.slim package. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Id: SlimResponse.java,v 1.1 2002/08/21 17:00:02 sei Exp $
 */
final class SlimResponse implements IResponse {

  private final int status;
  private final Headers headers;
  private final String description;
  private final String httpVersion;
  private Document document;
  private InputStream stream;

  public SlimResponse(HttpStatus status, Headers headers) {
    this.status = status.getCode();
    this.description = status.getDescription();
    this.httpVersion = status.getProtocol();
    this.headers = headers;
  }

  public Document getDocument() {
    return this.document;
  }

  public InputStream getStream() {
    return this.stream;
  }

  public String getContentType() {
    return (String)this.headers.get("Content-Type");
  }

  public long getContentLength() {
    String clen = (String)this.headers.get("Content-Length");
    if (clen != null) {
      try {
        return Long.parseLong(clen);
      }
      catch (Exception ex) {
            //$JL-EXC$
        return -1L;
      }
    }
    return -1L;
  }

  public String getHeader(String name) {
    return this.headers.get(name);
  }

  public Iterator getHeaderNames() {
    return this.headers.keys();
  }

  public String getHttpVersion() {
    return this.httpVersion;
  }

  public int getStatus() {
    return this.status;
  }

  public String getStatusDescription() {
    return this.description;
  }

  public boolean hasDocument() {
    return (this.document != null);
  }

  public boolean hasStream() {
    return (this.stream != null);
  }

  public void setDocument(Document document) {
    this.document = document;
  }

  public void setStream(InputStream stream) {
    this.stream = stream;
  }
}

