/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.http;

/**
 * Keeps username and password. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Id: UserInfo.java,v 1.1 2002/08/21 17:00:02 sei Exp $
 */
public final class UserInfo {

  public final static UserInfo ANONYMOUS = new UserInfo("anonymous", "");

  /**
   * Creates a new WDuserInfo object.
   *
   * @param user the user
   * @param password of user (maybe <code>null</code> )
   * @return WDuserInfo
   * @throws IllegalArgumentException if user is <code>null</code>
   */
  public static UserInfo valueOf(String user, String password) {
    if (user == null || user.length() == 0) {
      return ANONYMOUS;
    }
    return new UserInfo(user, password);
  }

  private final String user;
  private final String password;
  private final int hashCode;

  private UserInfo(String user, String password) {
    if (user == null) {
      throw new IllegalArgumentException("user cannot be null");
    }
    this.user = user;
    this.password = (password != null) ? password : "";
    int h = 17;
    h = 37 * h + this.user.hashCode();
    h = 37 * h + this.password.hashCode();
    this.hashCode = h;
  }

  /**
   * Returns user, alway != <code>null</code> .
   *
   * @return user
   */
  public String getUser() {
    return this.user;
  }

  /**
   * Returns password, alway != <code>null</code> .
   *
   * @return password
   */
  public String getPassword() {
    return this.password;
  }

  public boolean equals(Object other) {
    if (other instanceof UserInfo) {
      UserInfo o = (UserInfo)other;
      return this.hashCode == o.hashCode
         && this.user.equals(o.user)
         && this.password.equals(o.password);
    }
    return false;
  }

  public int hashCode() {
    return this.hashCode;
  }

  public String toString() {
    return "UserInfo[" + this.user + ",*****]";
//    return "UserInfo["+this.user+","+this.password+"]";
  }
}
