/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.http;

/**
 * Default Implementation of IRequesterFactory getter. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Id: RequesterFactory.java,v 1.1 2002/08/21 17:00:02 sei Exp $
 */
public class RequesterFactory {

  private final static com.sap.tc.logging.Location log = com.sap.tc.logging.Location.getLocation(com.sapportals.wcm.util.http.RequesterFactory.class);

  /**
   * Get new default instance of IRequesterFactory.
   *
   * @return new instance of requester factory
   */
  public static synchronized IRequesterFactory newInstance() {
    return RF.INSTANCE.newInstance();
  }

  /**
   * TBD: Description of the class.
   */
  private final static class RF {

    public final static RF INSTANCE = new RF();

    private final Class rfClass;

    private RF() {
      Class c = null;
      try {
        c = Class.forName("com.sapportals.wcm.util.http.slim.SlimRequesterFactory");
        if (!IRequesterFactory.class.isAssignableFrom(c)) {
          log.fatalT("RF(53)", "Class " + c.getName() + " is not instance of IRequesterFactory");
          c = null;
        }
      }
      catch (ClassNotFoundException e) {
        log.fatalT("RF(58)", "could not obtain http requester factory class" + " - " + com.sapportals.wcm.util.logging.LoggingFormatter.extractCallstack(e));
      }
      this.rfClass = c;
    }

    public IRequesterFactory newInstance() {
      try {
        return (IRequesterFactory)this.rfClass.newInstance();
      }
      catch (Exception e) {
        log.fatalT("newInstance(68)", "could not instantiate requester factory" + " - " + com.sapportals.wcm.util.logging.LoggingFormatter.extractCallstack(e));
        return null;
      }
    }
  }
}
