/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.http;

/**
 * IWDResponse represents the response to a HTTP request, as performed with an
 * IWDRequest. <p>
 *
 * Whether the IWDResponse keeps a {@link org.w3c.dom.Document} is influenced by
 * two factors:
 * <ol>
 *   <li> when the IWDRequest indicated that a response document is expected
 *   </li>
 *   <li> when the response carried a 207 status code with content type text/xml
 *   </li>
 * </ol>
 * However the document may still be <code>null</code> due to missing response
 * body, etc. </p> <p>
 *
 * Whether the IWDResponse keeps a InputStream is influenced mainly by the
 * indication in the IWDRequest, namely if the client indicates that he would
 * like to get the response as a InputStream. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Id: IResponse.java,v 1.1 2002/08/21 17:00:02 sei Exp $
 */
public interface IResponse {

  /**
   * @return the parsed XML Document from the HTTP response or <code>null</code>
   */
  public org.w3c.dom.Document getDocument();

  /**
   * @return an InputStream to read the body of a HTTP response from or <code>
   *      null</code>
   */
  public java.io.InputStream getStream();

  /**
   * @return the mime type of the response body or <code>null</code> if not
   *      specified
   */
  public String getContentType();

  /**
   * @return the length of the HTTP response body or <code>-1</code> if not
   *      specified
   */
  public long getContentLength();

  /**
   * @param name TBD: Description of the incoming method parameter
   * @return the HTTP header field with given name or <code>null</code> if not
   *      specified
   */
  public String getHeader(String name);

  /**
   * @return enumeration of all header fields in HTTP response
   */
  public java.util.Iterator getHeaderNames();

  /**
   * @return HTTP version string (RFC2616, section 3.1)
   */
  public String getHttpVersion();

  /**
   * @return HTTP status code of response
   */
  public int getStatus();

  /**
   * @return HTTP status description of response
   */
  public String getStatusDescription();

  /**
   * @return if HTTP response contained a valid XML document
   */
  public boolean hasDocument();

  /**
   * @return if InputStream for HTTP body is available
   */
  public boolean hasStream();

}

