/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.http;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.util.uri.HttpUrl;

/**
 * A requester factory is able to handle out new IWDRequester for a given base
 * URL. Context information can be supplied when the connection to the remote
 * URL requires Authorization. <p>
 *
 * For efficient reuse of requester, it is best to acquire the IWDContext
 * objects through the factory interface. At the moment there is only support
 * for user/password Authorization in this interface. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Id: IRequesterFactory.java,v 1.1 2002/08/21 17:00:02 sei Exp $
 */
public interface IRequesterFactory {

  /**
   * @return the installed base URL
   */
  public HttpUrl getBase();

  /**
   * @return the port number
   */
  public int getPort();

  /**
   * @param uri TBD: Description of the incoming method parameter
   * @return the full URL for the given relative URI
   */
  public String getAbsoluteURL(String uri);

  /**
   * @param key TBD: Description of the incoming method parameter
   * @return a IWDContext for the given key (e.g. username)
   */
  public IContext getContext(Object key);

  /**
   * Set the base URL for this factory. Needs to be called before first
   * requester is retrieved and should not be changed afterwards.
   *
   * @param url baseURL to be set
   * @exception java.net.MalformedURLException Exception raised in failure
   *      situation
   */
  public void setBaseURL(String url)
    throws java.net.MalformedURLException;

  /**
   * Sets the proxy information to use by this factory.
   *
   * @param info proxyInfo to be set
   */
  public void setProxyInfo(IProxyInfo info);

  /**
   * @param context needed for authorized connections or <code>null</code> for
   *      anonymous requests
   * @return IWDRequester for the given context.
   * @exception WcmException Exception raised in failure situation
   */
  public IRequester getRequester(IContext context)
    throws WcmException;

  /**
   * Returns the timeout used for socket operations. A timeout value of 0 means
   * infinite timeout.
   *
   * @return the timeout (milliseconds) used for socket operations
   */
  public int getSoTimeout();

  /**
   * Sets the timeout for socket operations. A value of 0 means inifinite wait.
   *
   * @param ms soTimeout to be set
   */
  public void setSoTimeout(int ms);

  /**
   * Set the maximum number of concurrent connections.
   *
   * @param max maximum number of connections
   */
  public void setMaxConnections(int max);
}

