/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.http;

import com.sapportals.wcm.WcmException;

/**
 * Requester have the main task to perform HTTP requests and return
 * IWDResponses. A requester can be used for a series of request until released
 * or closed. <p>
 *
 * Releasing a requester might make it available for further reuse. Closing a
 * requester explicitly disallows reuse. This might be necessary when there is
 * trouble with a request or, for example, when the response body needs to be
 * discarded. <p>
 *
 * Note that requester objects are <b>not</b> multithread safe. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Id: IRequester.java,v 1.1 2002/08/21 17:00:02 sei Exp $
 */
public interface IRequester {

  /**
   * Send a HTTP request to the remote server and deliver the response back to
   * the caller.
   *
   * @param request the HTTP request to perform
   * @return repsonse from the server
   * @throws WcmException on trouble with connection
   */
  public IResponse perform(IRequest request)
    throws WcmException;

  /**
   * Release this requester and make it available for reuse.
   */
  public void release();

  /**
   * Close the requester and disallow reuse. The underlying connection will be
   * closed.
   */
  public void close();

  /**
   * Returns the timeout used for socket operations. A timeout value of 0 means
   * infinite timeout.
   *
   * @return the timeout (milliseconds) used for socket operations
   */
  public int getSoTimeout();

  /**
   * Sets the timeout for socket operations. A value of 0 means inifinite wait.
   *
   * @param ms soTimeout to be set
   */
  public void setSoTimeout(int ms);

}

