/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.http;

import com.sapportals.wcm.util.uri.IUriReference;

/**
 * Interface for HTTP request passed on to a IWDRequester, which performs the
 * request. The request has information about the base URL for all requests. As
 * a consequence all URIs used in requests are relative to the base URL. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Id: IRequest.java,v 1.1 2002/08/21 17:00:02 sei Exp $
 */

public interface IRequest {

  /**
   * @return the body of the request as string or null
   */
  public String getBody();

  /**
   * @return the body of the request as input stream or null
   */
  public java.io.InputStream getBodyStream();

  /**
   * @param name TBD: Description of the incoming method parameter
   * @return header information for given name (or null).
   */
  public String getHeader(String name);

  /**
   * @param name TBD: Description of the incoming method parameter
   * @return if header information for name was added (using comma as separator)
   */
  public boolean wasAddedHeader(String name);

  /**
   * @return all headers set for the request
   */
  public java.util.Iterator getHeaderNames();

  /**
   * @return method of request
   */
  public String getMethod();

  /**
   * @return URI used for request relative to base URL of requester
   */
  public String getURI();

  /**
   * @return Uri reference used for request relative to base URL of requester
   */
  public IUriReference getReference();

  /**
   * @return if a body has been set for the request
   */
  public boolean hasBody();

  /**
   * @return if the request expects a XML Document in response
   */
  public boolean expectsResponseDocument();

  /**
   * @return if the request expects an InputStream for the response body
   */
  public boolean expectsResponseStream();

  /**
   * Set header field for request. Replaces any existing header information with
   * the same name.
   *
   * @param name name of header field
   * @param value value of header field
   */
  public void setHeader(String name, String value);

  /**
   * Add header field for request. Will keep any existing header information
   * with the same name.
   *
   * @param name name of header field
   * @param value value of header field
   */
  public void addHeader(String name, String value);
}

