/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.http;

import com.sapportals.wcm.util.uri.HttpUrl;

/**
 * An IWDProxyInfo objects keeps information about proxy servers for http
 * requests and determines if for a given hostname the proxy shall be used. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Id: IProxyInfo.java,v 1.1 2002/08/21 17:00:02 sei Exp $
 */

public interface IProxyInfo {

  /**
   * Get URL of proxy for given server. Returns <code>null</code> if no proxy is
   * defined for the server.
   *
   * @param server url
   * @return proxy url
   */
  public HttpUrl getProxyFor(HttpUrl server);

  /**
   * @param scheme TBD: Description of the incoming method parameter
   * @return the system id of the proxy server (or null if none defined)
   */
  public String getProxySystemID(String scheme);

}

