/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: IExtendedCookie.java,v 1.1 2004/01/27 13:57:55 sei Exp $
 */
package com.sapportals.wcm.util.http;

/**
 * HTTP cookie with extended functionality <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Id: IExtendedCookie.java,v 1.1 2004/01/27 13:57:55 sei Exp $
 */
public interface IExtendedCookie extends ICookie {

  /**
   * Return when the cookie was set by the server
   * @return when cookie was set by server
   */
  public long getCreationTime();
  
  /**
   * Get time when cookie will expire. If no expiry is set,
   * Long.MAX_VALUE will be returned
   * @return time of cookie expiry
   */
  public long getExpiryTime();
  
  /**
   * Create a cookie with same values as this and expiration set
   * to the given expiry time.
   * @param expires when cookie will expire (ms since epoch)
   * @return new cookie with given expiration time
   */
  public IExtendedCookie setExpiryTime(long expires);
}
