/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.http;

import com.sapportals.wcm.util.uri.IUri;

/**
 * HTTP cookie. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Id: ICookie.java,v 1.1 2002/08/21 17:00:02 sei Exp $
 */
public interface ICookie {

  /**
   * Determine if cookie has expired
   *
   * @return if cookie has expired
   */
  public boolean isExpired();

  /**
   * Determine if cookie applies to uri
   *
   * @param uri TBD: Description of the incoming method parameter
   * @return if cookie applues to uri
   */
  public boolean appliesTo(IUri uri);

  /**
   * Get key under which this cookie can be stored. Must be unique across
   * domains and paths and names.
   *
   * @return key for storage of cookie
   */
  public String getKey();

  /**
   * Get Version cookie was created with (0 = unknown).
   *
   * @return version of cookie protocol
   */
  public int getVersion();

  /**
   * Get cookie value suitable for sending back to server. The value is the HTTP
   * header value, without leading &quot;Cookie:&quot; and without leading
   * version information.
   *
   * @return HTTP header value
   */
  public String getHeaderValue();
}
