/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: ConnectException.java,v 1.1 2004/06/25 13:08:09 sei Exp $
 */

package com.sapportals.wcm.util.http;

import com.sapportals.wcm.WcmException;

/**
 * Signals connection problems.
 * 
 * Copyright (c) SAP AG 2004
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Id: ConnectException.java,v 1.1 2004/06/25 13:08:09 sei Exp $
 */

public class ConnectException extends WcmException {

  private String host;
  private String reason;
  private int retryInSec;
  
  public ConnectException(String host, String reason, int retryInSec, Throwable ex) {
    super("unable to connect to "+host+": "+reason, ex, false);
    this.host = host;
    this.reason = reason;
    this.retryInSec = retryInSec;
  }
  
  /**
   * Gets the name of the host to which the connection failed
   * @return name of the host to which the connection failed
   */
  public String getHost() {
    return this.host;
  }
  
  /**
   * Gets the reason why the connection failed (if known)
   * @return reason of connection failure
   */
  public String getReason() {
    return this.reason;
  }
  
  /**
   * Get the recommended retry interval in seconds
   * @return the recommended retry interval in seconds
   */
  public int getRetryInSec() {
    return this.retryInSec;
  }
}
