/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.http;

import com.sapportals.wcm.WcmException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

/**
 * Yet another base64 implementation. <p>
 *
 * Copyright (c) SAP AG 2001-2003
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Id: Base64.java,v 1.4 2003/02/17 14:24:04 jre Exp $
 */
public class Base64 {

  // The base map of 6-bit numbers to charcters according to RFC 2045
  //
//  private static final char[] m_mapBase = new char[] {
//    'A', 'B', 'C', 'D',
//    'E', 'F', 'G', 'H',
//    'I', 'J', 'K', 'L',
//    'M', 'N', 'O', 'P',
//    'Q', 'R', 'S', 'T',
//    'U', 'V', 'W', 'X',
//    'Y', 'Z', 'a', 'b',
//    'c', 'd', 'e', 'f',
//    'g', 'h', 'i', 'j',
//    'k', 'l', 'm', 'n',
//    'o', 'p', 'q', 'r',
//    's', 't', 'u', 'v',
//    'w', 'x', 'y', 'z',
//    '0', '1', '2', '3',
//    '4', '5', '6', '7',
//    '8', '9', '+', '/',
//  };

  // The map for the first byte of three (b1+b2+b3)
  // - just taking b1
  //
  private final static char[] m_map0 = new char[]{
    'A', 'A', 'A', 'A', 'B', 'B', 'B', 'B',
    'C', 'C', 'C', 'C', 'D', 'D', 'D', 'D',
    'E', 'E', 'E', 'E', 'F', 'F', 'F', 'F',
    'G', 'G', 'G', 'G', 'H', 'H', 'H', 'H',
    'I', 'I', 'I', 'I', 'J', 'J', 'J', 'J',
    'K', 'K', 'K', 'K', 'L', 'L', 'L', 'L',
    'M', 'M', 'M', 'M', 'N', 'N', 'N', 'N',
    'O', 'O', 'O', 'O', 'P', 'P', 'P', 'P',
    'Q', 'Q', 'Q', 'Q', 'R', 'R', 'R', 'R',
    'S', 'S', 'S', 'S', 'T', 'T', 'T', 'T',
    'U', 'U', 'U', 'U', 'V', 'V', 'V', 'V',
    'W', 'W', 'W', 'W', 'X', 'X', 'X', 'X',
    'Y', 'Y', 'Y', 'Y', 'Z', 'Z', 'Z', 'Z',
    'a', 'a', 'a', 'a', 'b', 'b', 'b', 'b',
    'c', 'c', 'c', 'c', 'd', 'd', 'd', 'd',
    'e', 'e', 'e', 'e', 'f', 'f', 'f', 'f',
    'g', 'g', 'g', 'g', 'h', 'h', 'h', 'h',
    'i', 'i', 'i', 'i', 'j', 'j', 'j', 'j',
    'k', 'k', 'k', 'k', 'l', 'l', 'l', 'l',
    'm', 'm', 'm', 'm', 'n', 'n', 'n', 'n',
    'o', 'o', 'o', 'o', 'p', 'p', 'p', 'p',
    'q', 'q', 'q', 'q', 'r', 'r', 'r', 'r',
    's', 's', 's', 's', 't', 't', 't', 't',
    'u', 'u', 'u', 'u', 'v', 'v', 'v', 'v',
    'w', 'w', 'w', 'w', 'x', 'x', 'x', 'x',
    'y', 'y', 'y', 'y', 'z', 'z', 'z', 'z',
    '0', '0', '0', '0', '1', '1', '1', '1',
    '2', '2', '2', '2', '3', '3', '3', '3',
    '4', '4', '4', '4', '5', '5', '5', '5',
    '6', '6', '6', '6', '7', '7', '7', '7',
    '8', '8', '8', '8', '9', '9', '9', '9',
    '+', '+', '+', '+', '/', '/', '/', '/',
    };

  // The map for the first+second byte of three (b1+b2+b3)
  // - just taking (b1 & 0x03) + (b2 & 0xf0)
  //
  private static char[] m_map1 = new char[]{
    'A', 'Q', 'g', 'w', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    'B', 'R', 'h', 'x', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    'C', 'S', 'i', 'y', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    'D', 'T', 'j', 'z', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    'E', 'U', 'k', '0', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    'F', 'V', 'l', '1', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    'G', 'W', 'm', '2', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    'H', 'X', 'n', '3', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    'I', 'Y', 'o', '4', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    'J', 'Z', 'p', '5', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    'K', 'a', 'q', '6', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    'L', 'b', 'r', '7', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    'M', 'c', 's', '8', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    'N', 'd', 't', '9', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    'O', 'e', 'u', '+', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    'P', 'f', 'v', '/', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    };

  // The map for the second+third byte of three (b1+b2+b3)
  // - just taking (b2 & 0x0f) + (b3 & 0xc0)
  //
  private static char[] m_map2 = new char[]{
    'A', 'E', 'I', 'M', 'Q', 'U', 'Y', 'c',
    'g', 'k', 'o', 's', 'w', '0', '4', '8',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    'B', 'F', 'J', 'N', 'R', 'V', 'Z', 'd',
    'h', 'l', 'p', 't', 'x', '1', '5', '9',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    'C', 'G', 'K', 'O', 'S', 'W', 'a', 'e',
    'i', 'm', 'q', 'u', 'y', '2', '6', '+',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    'D', 'H', 'L', 'P', 'T', 'X', 'b', 'f',
    'j', 'n', 'r', 'v', 'z', '3', '7', '/',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    };

  // The map for the third byte of three (b1+b2+b3)
  // - just taking b3
  //
  private final static char[] m_map3 = new char[]{
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H',
    'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P',
    'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X',
    'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f',
    'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n',
    'o', 'p', 'q', 'r', 's', 't', 'u', 'v',
    'w', 'x', 'y', 'z', '0', '1', '2', '3',
    '4', '5', '6', '7', '8', '9', '+', '/',
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H',
    'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P',
    'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X',
    'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f',
    'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n',
    'o', 'p', 'q', 'r', 's', 't', 'u', 'v',
    'w', 'x', 'y', 'z', '0', '1', '2', '3',
    '4', '5', '6', '7', '8', '9', '+', '/',
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H',
    'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P',
    'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X',
    'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f',
    'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n',
    'o', 'p', 'q', 'r', 's', 't', 'u', 'v',
    'w', 'x', 'y', 'z', '0', '1', '2', '3',
    '4', '5', '6', '7', '8', '9', '+', '/',
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H',
    'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P',
    'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X',
    'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f',
    'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n',
    'o', 'p', 'q', 'r', 's', 't', 'u', 'v',
    'w', 'x', 'y', 'z', '0', '1', '2', '3',
    '4', '5', '6', '7', '8', '9', '+', '/',
    };

  // reverse map the coding chars to 6-bit numbers
  //
  private static int[] m_rmap = new int[]{
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63,
    52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1,
    -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,
    15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1,
    -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
    41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    };

  /**
   * Base64 encode the string in buffer according to RFC 2045. Default character
   * encoding is applied to buffer.
   *
   * @param buffer TBD: Description of the incoming method parameter
   * @return the encoded bytes
   */
  public static String encode(String buffer) {
    return encode(buffer.getBytes());
  }

  /**
   * Base64 encode the string in buffer according to RFC 2045 with specified
   * character encoding.
   *
   * @param buffer to encode
   * @param encoding to use
   * @return the encoded bytes
   */
  public static String encode(String buffer, String encoding) throws UnsupportedEncodingException {
    return encode(buffer.getBytes(encoding));
  }

  /**
   * Base64 encode the bytes in buffer according to RFC 2045.
   *
   * @param buffer to encode
   * @return the encoded bytes
   */
  public static String encode(byte[] buffer) {
    return encode(buffer, 60);
  }

  /**
   * Base64 encode the bytes in buffer. Insert cr+lf after linelen characters.
   *
   * @param buffer to encode
   * @param linelen to use
   * @return the encoded bytes
   */
  public static String encode(byte[] buffer, int linelen) {
    StringBuffer sb = new StringBuffer((buffer.length + 2) / 3 * 4);
    int group = 0;
    int mode = 0;
    int last = 0;
    int maxgroup = (linelen / 3) - 1;
    for (int i = 0; i < buffer.length; ++i) {
      int b = buffer[i] & 0xff;
      switch (mode) {
        case 0:
          ++group;
          if (group == maxgroup) {
            sb.append("\r\n");
            group = 0;
          }
          sb.append(m_map0[b]);
          last = (b & 0x03);
          mode = 1;
          break;
        case 1:
          sb.append(m_map1[last | (b & 0xf0)]);
          last = (b & 0x0f);
          mode = 2;
          break;
        case 2:
          sb.append(m_map2[last | (b & 0xc0)]);
          sb.append(m_map3[b]);
          mode = 0;
          break;
      }
    }

    switch (mode) {
      case 0:
        break;
      case 1:
        sb.append(m_map1[last]);
        sb.append("==");
        break;
      case 2:
        sb.append(m_map2[last]);
        sb.append('=');
        break;
    }

    return sb.toString();
  }

  /**
   * Base64 decode the string in the buffer according to RFC 2045.
   *
   * @param buffer TBD: Description of the incoming method parameter
   * @return the original bytes
   * @exception WcmException Exception raised in failure situation
   */
  public static byte[] decode(String buffer)
    throws WcmException {
    int mode = 0;
    int len = buffer.length();
    byte[] result = new byte[len];
    int bytes = 0;
    byte b = 0;
    int offset = 0;
    for (int i = 0; i < len; ++i) {
      char c = buffer.charAt(i);
      byte current = 0;
      if (c != '=') {
        current = (byte)m_rmap[c];
        if (current < 0) {
          continue;
        }
        if (mode != 0) {
          ++bytes;
        }
      }
      switch (mode) {
        case 0:
          b = (byte)((current) << 2);
          mode = 1;
          break;
        case 1:
          b |= (current & 0xf0) >>> 4;
          result[offset++] = b;
          b = (byte)((current & 0x0f) << 4);
          mode = 2;
          break;
        case 2:
          b |= (current & 0xfc) >>> 2;
          result[offset++] = b;
          b = (byte)((current & 0x03) << 6);
          mode = 3;
          break;
        case 3:
          b |= current;
          result[offset++] = b;
          mode = 0;
          break;
      }
    }
    if (mode != 0) {
      throw new WcmException("unexpected end of base64 encoded string", false);
    }

    byte[] bs = new byte[bytes];
    System.arraycopy(result, 0, bs, 0, bytes);
    return bs;
  }

  /**
   * Base64 decode the string in the buffer according to RFC 2045. Convenience
   * method when it is known the the orignal consisted of characters. Platform
   * default charset applies!
   *
   * @param buffer TBD: Description of the incoming method parameter
   * @return the original string
   * @exception WcmException Exception raised in failure situation
   */
  public static String decodeString(String buffer)
    throws WcmException {
    ByteArrayOutputStream bos = new ByteArrayOutputStream();
    try {
      bos.write(decode(buffer));
      return bos.toString();
    }
    catch (IOException ex) {
      throw new WcmException(ex, false);
    }
  }

  /**
   * Generates different maps on stdout. Gee, are we lazy...
   */
  /*
   * public static void main(String[] args) throws WcmException {
   * genMap1();
   * genMap2();
   * genReverseMap();
   * testit("The quick brown fox jumps over the lazy dog.");
   * testit("a little test string which is inside one line");
   * testit("a little test string which is inside one line1");
   * testit("a little test string which is inside one line12");
   * testit("a little test string which is inside one line123");
   * testit("@");
   * testit("a little test string which is a little bit longer than one line");
   * testit("Aladdin:open sesame");
   * }
   * private static void genMap1() {
   * char[] buffer = new char[256];
   * for (int i = 0; i < buffer.length; ++i) {
   * buffer[i] = ' ';
   * }
   * for (int i = 0; i < m_mapBase.length; ++i) {
   * int perm = ((i&0x30) >>> 4) | ((i&0x0f) << 4);
   * System.out.println(perm);
   * buffer[perm] = m_mapBase[i];
   * }
   * int items = -1;
   * System.out.print("private static char[] m_map1 = new char[] {\n  ");
   * for (int i = 0; i < buffer.length; ++i) {
   * ++items;
   * if (items == 8) {
   * System.out.print("\n    ");
   * items = 0;
   * }
   * System.out.print("\'"+buffer[i]+"\', ");
   * }
   * System.out.println("\n  };");
   * }
   * private static void genMap2() {
   * char[] buffer = new char[256];
   * for (int i = 0; i < buffer.length; ++i) {
   * buffer[i] = ' ';
   * }
   * for (int i = 0; i < m_mapBase.length; ++i) {
   * int perm = ((i&0x3c) >>> 2) | ((i&0x03) << 6);
   * System.out.println(perm);
   * buffer[perm] = m_mapBase[i];
   * }
   * int items = -1;
   * System.out.print("private static char[] m_map2 = new char[] {\n  ");
   * for (int i = 0; i < buffer.length; ++i) {
   * ++items;
   * if (items == 8) {
   * System.out.print("\n    ");
   * items = 0;
   * }
   * System.out.print("\'"+buffer[i]+"\', ");
   * }
   * System.out.println("\n  };");
   * }
   * private static void genReverseMap() {
   * int[] buffer = new int[256];
   * for (int i = 0; i < buffer.length; ++i) {
   * buffer[i] = -1;
   * }
   * for (int i = 0; i < m_mapBase.length; ++i) {
   * buffer[m_mapBase[i]] = i;
   * }
   * int items = -1;
   * System.out.print("private static int[] m_rmap = new int[] {\n  ");
   * for (int i = 0; i < buffer.length; ++i) {
   * ++items;
   * if (items == 16) {
   * System.out.print("\n  ");
   * items = 0;
   * }
   * int n = buffer[i];
   * if (n >= 0 && n < 10) {
   * System.out.print(' ');
   * }
   * System.out.print(n);
   * System.out.print(", ");
   * }
   * System.out.println("\n};");
   * }
   * private static void testit(String test) throws WcmException {
   * System.out.println("testing: "+test);
   * String code = encode(test.getBytes());
   * System.out.println(code);
   * String tmp = decodeString(code);
   * System.out.println("decoded: "+tmp);
   * System.out.println("equal: "+test.equals(tmp));
   * }
   */
}

