/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.html;

/**
 * Processes HTML events from a parent reader. <p>
 *
 * The Filter is a reader which takes events from another reader, processes them
 * and passes them on to its {@link IHTMLContentHandler}. <p>
 *
 * Copyright (c) SAP AG 2001-2003
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Id: IHTMLFilter.java,v 1.4 2003/03/20 18:41:30 jre Exp $
 */
public interface IHTMLFilter extends IHTMLReader {

  /**
   * Get the reader this filter gets its events from.
   *
   * @return parent reader
   */
  public IHTMLReader getParent();

  /**
   * Set the reader where this filter should get its events from.
   *
   * @param reader new parent reader
   */
  public void setParent(IHTMLReader reader);

}
