/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.html;

/**
 * Extends {@link IHTMLElement} to handle attributes. <p>
 *
 * This class extends {@link IHTMLElement} with the capabilities to handle
 * element attributes which can appear in start elements. <p>
 *
 * It is possible to change the attributes of an element, to remove attributes
 * and to add new ones. Note that namespace declarations will appear as normal
 * attributes on an element. The name of an attribute is the <a
 * href="http://www.w3.org/TR/1999/REC-xml-names-19990114/#ns-qualnames">
 * Qualified Name</a> . So it will include possible namespace prefixes. <p>
 *
 * Copyright (c) SAP AG 2001-2003
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Id: IHTMLElementStart.java,v 1.5 2003/03/20 18:41:30 jre Exp $
 */
public interface IHTMLElementStart extends IHTMLElement {

  /**
   * Determines if this element is an empty element, e.g. ending with '/&gt;'.
   * Note that an empty element can have attributes.
   *
   * @return if element is empty
   */
  public boolean isEmpty();

  /**
   * Return the number of attributes this element has.
   *
   * @return number of attributes
   */
  public int getNumberOfAttributes();

  /**
   * Find the index of the attribute of given name or <code>-1</code> .
   *
   * @param attributeName of attribute to find
   * @return the index of attribute or <code>-1</code> if not found
   */
  public int getIndexOf(String attributeName);

  /**
   * Retrieve the name of the attribute with given index.
   *
   * @param attributeIndex of attribute
   * @return name of attribute
   */
  public String getNameOf(int attributeIndex);

  /**
   * Retrieve the value of the attribute with given index. Note that the value
   * of an attribute does not include surrounding quotes.
   *
   * @param attributeIndex of attribute
   * @return value of attribute
   */
  public String getValueOf(int attributeIndex);

  /**
   * Set the value of attribute with given index to a new value.
   *
   * @param attributeIndex of attribute
   * @param value new value
   */
  public void setValueOf(int attributeIndex, String value);

  /**
   * Remove attribute with given index. Indexes of remaining attributes are
   * recalculated.
   *
   * @param attributeIndex of attribute
   */
  public void removeAttribute(int attributeIndex);

  /**
   * Add a new attribute with given name and value.
   *
   * @param name of new attribute
   * @param value of new attribute
   * @throws HTMLException if attribute with same name already exists
   */
  public void addAttribute(String name, String value)
    throws HTMLException;

}
