/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.html;

import java.io.IOException;
import java.io.Writer;

/**
 * Represents a HTML tag for an event. <p>
 *
 * This class represents a HTML tag for element events during parsing. The
 * element has the following properties:
 * <ul>
 *   <li> <b>Name</b> : the name of the tag. If the underlying document is
 *   xhtml, the name of an element is the <a
 *   href="http://www.w3.org/TR/1999/REC-xml-names-19990114/#ns-qualnames">
 *   Qualified Name</a> as defined in <a
 *   href="http://www.w3.org/TR/1999/REC-xml-names-19990114/">XML Namespaces</a>
 *   . So, namespace prefixes will be part of the element name. </li>
 *   <li> <b>Length</b> : the number of characters this element has. Note that
 *   angular brackets are part of the element, so '&lt;tag&gt;' has length 5.
 *   </li>
 * </ul>
 * <p>
 *
 * Copyright (c) SAP AG 2001-2003
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Id: IHTMLElement.java,v 1.6 2003/03/20 18:41:30 jre Exp $
 */
public interface IHTMLElement {

  /**
   * Returns the element name. See {@link #hasName(String)} for a cheaper method to
   * compare names, if that is all you're interested in.
   *
   * @return the name of the element
   */
  public String getName();

  /**
   * Returns the length of the element name.
   *
   * @return length of element name
   */
  public int getNameLength();

  /**
   * Check if element has specified name. The check is done case-insensitiv.
   *
   * @param name to check against
   * @return if element name equalsIgnoreCase the given name
   */
  public boolean hasName(String name);

  /**
   * Copy all characters of this element into the given buffer. Ensure that the
   * buffer can keep {@link #length()} chars.
   *
   * @param ch buffer to copy to
   * @param offset where in the buffer to start
   * @return number of characters copied
   */
  public int copyTo(char[] ch, int offset);

  /**
   * Return the number of characters this element has.
   *
   * @return element length
   */
  public int length();

  /**
   * Copy the characters of this element onto the given Writer.
   *
   * @param writer to write characters to
   * @return number of characters written
   * @throws IOException on failure from writer
   */
  public int writeTo(Writer writer)
    throws IOException;
}
