/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.html;

/**
 * Removes script content and noscript tags. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Id: HTMLScriptRemover.java,v 1.1 2002/03/06 09:22:54 sei Exp $
 */
public class HTMLScriptRemover extends HTMLFilterImpl {

  private boolean inScript;

  public HTMLScriptRemover() { }

  public HTMLScriptRemover(IHTMLReader reader) {
    super(reader);
  }

  public void startElement(IHTMLElementStart element)
    throws HTMLException {
    switch (element.getNameLength()) {
      case 6:
        if (element.hasName("script")) {
          this.inScript = !element.isEmpty();
          return;
        }
        break;
      case 8:
        if (element.hasName("noscript")) {
          return;
        }
        break;
      default:
        break;
    }

    super.startElement(element);
  }

  public void endElement(IHTMLElement element)
    throws HTMLException {
    if (element.hasName("script")) {
      this.inScript = false;
      return;
    }
    if (element.hasName("noscript")) {
      return;
    }
    super.endElement(element);
  }

  public void characters(char[] ch, int start, int length)
    throws HTMLException {
    if (this.inScript) {
      return;
    }
    super.characters(ch, start, length);
  }
}
