/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.html;

/**
 * HTMLReaderFactory creates instances of IHTMLReader. <p>
 *
 * Copyright (c) SAP AG 2001-2003
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Id: HTMLReaderFactory.java,v 1.4 2003/03/20 18:41:30 jre Exp $
 */
public class HTMLReaderFactory {

  /**
   * Creates a new instance of IHTMLReader with default settings
   *
   * @return new instance of IHTMLReader
   * @throws HTMLException on setup errors.
   */
  public static IHTMLReader createHTMLReader()
    throws HTMLException {
    return new HTMLReaderImpl();
  }
}
