/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.enum;

/**
 * Base class for type safe enumeration constants * Copyright (c) SAP AG
 * 2001-2002
 *
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/api/com/sapportals/wcm/util/enum/AbstractEnum.java#5
 *      $
 */
public abstract class AbstractEnum implements java.io.Serializable {

  protected int m_code;
  protected String description;
  
  protected AbstractEnum(int code) {
    m_code = code;
  }
  
  protected AbstractEnum(int code, String description) {
    this( code );
    this.description = description;
  }
  
  protected int getValue() {
    return m_code;
  }

  public boolean equals(Object code) {
    return (m_code == ((AbstractEnum)code).getValue());
  }
  
  public String toString() {
		if( this.description == null ) {
			return super.toString();
		}
    return this.description;
  }
}
