/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.controlstatus;

import com.sapportals.wcm.util.enum.AbstractEnum;

/**
 * TBD: Description of the class.
 */
public final class Status extends AbstractEnum {

  public final static Status OK = new Status(1);
  public final static Status WARNING = new Status(2);
  public final static Status ERROR = new Status(3);
  public final static Status ABORT = new Status(4);
  public final static Status NONE = new Status(5);

  private Status(int code) {
    super(code);
  }
  
  public String toString() {
    if (this.getValue() == 1) {
      return "OK";
    }	
    if (this.getValue() == 2) {
      return "WARNING";
    }
    if (this.getValue() == 3) {
      return "ERROR";
    }
    if (this.getValue() == 4) {
      return "ABORT";
    }            
    return "NONE";
  }	
  
  public static Status sort(Status a, Status b, boolean ascending) {
    if ((a == null) || (b == null)) {
      throw new NullPointerException("The parameter a <" + a + "> and b <" + b + "> must not be <null>");
    }	
    if (a.getValue() == 5) {
      return b;
    }	
    
    if (a.getValue() > b.getValue()) {
      if (ascending) {
      	return a;
      }	else {
      	return b;
      }	
    }
    
    return a;	
  }	
}
