/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.controlstatus;

import java.util.*;

/**
 * TBD: Description of the class.
 */
public class SelectionField extends Field implements ISelectionField {

  private Properties values = null;
  private String currentid = null;

  public SelectionField(FieldIdentifier id, Properties values, String currentid, HashMap metainfo, boolean mutable, ICondition condition, Locale locale) {
    super(id, values.getProperty(currentid), metainfo, mutable, condition, locale);
    this.values = values;
    this.currentid = currentid;
  }

  public SelectionField(FieldIdentifier id, Properties values, String currentid, HashMap metainfo, Locale locale) {
    super(id, values.getProperty(currentid), metainfo, locale);
    this.values = values;
    this.currentid = currentid;
  }

  public String getCurrentID() {
    return this.currentid;
  }

  public void setCurrentID(String id) {
    if (id != null) {
      if (this.getValueList().getProperty(id) != null) {
        this.currentid = id;
      }
    }
  }

  public Properties getValueList() {
    return this.values;
  }

  public String getCurrentValue() {
    return this.getValueList().getProperty(this.getCurrentID());
  }
}
