/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.controlstatus;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.util.usermanagement.*;
import java.util.*;

/**
 * TBD: Description of the class.
 */
public class PrincipalsField extends Field {

  //user handling specific
  private SelectionUserManager sum = null;
  private boolean allowEmail = false;
  private boolean allowUnchecked = false;
  private boolean invalidInput = false;
  private String userInput = null;

  public PrincipalsField(FieldIdentifier id, String currentvalue, HashMap metainfo, boolean readonly, Locale locale, boolean email, boolean unchecked) {
    super(id, currentvalue, metainfo, readonly, null, locale);
    this.allowEmail = email;
    this.allowUnchecked = unchecked;
    this.initialize();
  }

  /**
   * shortened Constructor, which will set the following values for the dropped
   * parameters readonly will be set to <code>false</code> condition will be set
   * to <code>null</code>
   *
   * @param id TBD: Description of the incoming method parameter
   * @param currentvalue TBD: Description of the incoming method parameter
   * @param metainfo TBD: Description of the incoming method parameter
   * @param locale TBD: Description of the incoming method parameter
   */
  public PrincipalsField(FieldIdentifier id, String currentvalue, HashMap metainfo, Locale locale) {
    this(id, currentvalue, metainfo, false, locale, false, false);
  }

  public void addPrincipalToList(String id, int typeoflist)
    throws WcmException {
    if (id != null) {
      this.sum.setList(id, typeoflist);
    }
  }

  public void addPrincipalsToList(String ids[], int typeoflist)
    throws WcmException {
    if (ids != null) {
      this.sum.setList(ids, typeoflist);
    }
  }

  public String[] getIDs(int typeoflist) {
    return this.sum.getIDs(typeoflist);
  }

  public boolean isInvalidIDGiven() {
    return this.sum.isInvalidIDGiven();
  }

  public boolean isNonUniqueIDGiven() {
    return this.sum.isNonUniqueIDGiven();
  }

  public String getInvalidIDs() {
    return this.sum.getInvalidIDs();
  }

  public String[] getNonUniqueIDs(int typeoflist)
    throws WcmException {
    return this.convertCollection2Array(typeoflist);
  }

  /**
   * clears all prior settings by creating a new instance of a <code>
   * SelectionUserManager</code>
   */
  public void reset() {
    this.initialize();
    this.userInput = null;
  }

  /**
   * inherited from <code>Field</code>
   *
   * @return currentValue
   */
  public String getCurrentValue() {
    if (this.sum.isInvalidIDGiven()) {
      return this.userInput;
    }
    else {
      return this.sum.getDisplayString();
    }
  }

  /**
   * inherited from <code>Field</code>
   *
   * @param value currentValue to be set
   */
  public void setCurrentValue(String value) {
    try {
//      first check, if the user manager must be reset - this is necessary, if
//      no input is given (then we need a um with no entries) or if there has been
//      an invalid id given (then we need a um that will be refreshed with the current
//      user input
      if ((value == null) || (this.sum.isInvalidIDGiven())) {
        this.reset();
      }
      if (value != null) {
        this.sum.handleAll(value);
        if (this.sum.isInvalidIDGiven()) {
          this.userInput = value;
        }
      }
    }
    catch (WcmException e) {
      com.sap.tc.logging.Location.getLocation(this.getClass()).debugT(e.getMessage());      
    }
  }

  private void initialize() {
    this.sum = new SelectionUserManager(this.allowEmail, this.allowUnchecked);
  }

  private String[] convertCollection2Array(int typeOfList)
    throws WcmException {
    Collection coll = (Collection)this.sum.getNonUniqueIDs().get(new Integer(typeOfList).toString());
    if (coll == null) {
      return null;
    }
    String[] returnArray = new String[coll.size()];
    int i = 0;
    Iterator iter = coll.iterator();
    while (iter.hasNext()) {
      returnArray[i++] = (String)iter.next();
    }
    return returnArray;
  }

}
