/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.controlstatus;

/**
 * TBD: Description of the class.
 */
public class NoEmptyStringCondition implements ICondition {

  public NoEmptyStringCondition() { }

  public boolean isValid(Object obj) {
    if (obj instanceof String) {
      String val = (String)obj;
      if (!val.trim().equals("")) {
        return true;
      }
    }
    return false;
  }

  public StatusInformation getValidity(Object obj) {
    if (obj instanceof String) {
      String val = (String)obj;
      if (!val.trim().equals("")) {
        return null;
      }
    }
    return new StatusInformation(Status.ERROR, null);
  }

}
