/*
 * Created on 11.12.2003
 * @since
 * @author
 * Copyright (c) SAP AG 2003
 */
package com.sapportals.wcm.util.controlstatus;

import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;

import com.sapportals.wcm.util.controlstatus.MetaInfo;
import com.sapportals.wcm.util.resource.ResourceBundles;

/**
 * @author d032991
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public final class MetaInfoMap extends HashMap {

	private static com.sap.tc.logging.Location log = com.sap.tc.logging.Location.getLocation(MetaInfoMap.class.getName());

  /**
   * creates a new instance that holds two map entries - label and tooltip.
   * This will create an untranslated meta info.
   * @param label
   * @param tooltip
   */
	public MetaInfoMap(String label, String tooltip) {
		super();
		this.put(MetaInfo.LABEL  , label);
		this.put(MetaInfo.TOOLTIP, tooltip);
	}
	
	/**
	 * creates a new instance that holds two map entries - label and tooltip.
	 * The tooltip will hold the same value as the label. This constructor will
	 * create an untranslated meta info
	 * @param label
	 */	
	public MetaInfoMap(String label) {
		super();
		this.put(MetaInfo.LABEL  , label);
		this.put(MetaInfo.TOOLTIP, label);
	}	
	
	/**
	 * creates a new, translated metamap instance. None of the parameters must be 
	 * <code>null</code>.
	 */
	public MetaInfoMap(String labelkey, String tooltipkey, Locale locale, ResourceBundles bundle) {
		super();
		if ((labelkey   == null) ||
			  (tooltipkey == null) ||
			  (locale     == null) ||
			  (bundle     == null)) {
			throw new NullPointerException("The parameters labelkey <" + labelkey + 
																		 ">, tooltipkey <" + tooltipkey +
																		 ">, locale     <" + locale +
																		 ">, bundle     <" + bundle + "> must not be <null>"); 	
		}
		
		//read out label from bundle, use key as fallback
		String label = labelkey;
		try {
      label = bundle.getString(labelkey, locale);
    } catch (MissingResourceException e) {
			if (log.beDebug()) {
				log.debugT("Could not get resource bundle entry for key <" + labelkey + " in bundle <" + bundle.toString() +">.");
			}
    }
		
		//read out tooltip from bundle, use key as fallback
		String tooltip = tooltipkey;
		try {
      tooltip = bundle.getString(tooltipkey, locale);
    } catch (MissingResourceException e1) {
			if (log.beDebug()) {
				log.debugT("Could not get resource bundle entry for key <" + tooltipkey + " in bundle <" + bundle.toString() +">.");
			}
    }
		
		this.put(MetaInfo.LABEL,   label);
		this.put(MetaInfo.TOOLTIP, tooltip);
	}

	/**
	 * creates a new, translated metamap instance. None of the parameters must be 
	 * <code>null</code>. The given labelkey will also be used to retrieve a tooltip.
	 */
	public MetaInfoMap(String labelkey, Locale locale, ResourceBundles bundle) {
		this(labelkey, labelkey, locale, bundle);
	}
}
