/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.controlstatus;

import java.util.List;

/**
 * model to allow handling of mass data. If an <code>IControlStatus</code> holds
 * information and allows modification of one instance of a certain type, this
 * interface allows handling of a list of instances of a certain type. These
 * instances are handled internally as a <code>List</code> and therefore allows
 * to access these instances via their index number (a.k.a. the position) within
 * this list.
 */
public interface IMassDataControlStatus {

  /**
   * returns the number of entries that are managed within this status
   *
   * @return entrySize
   */
  public int getEntrySize();

  /**
   * returns all fields that will be available for the managed types of this
   * class. The returned fields could not hold any values, but will provide
   * meta-information and the according <code>FieldIdentifier</code> values.
   *
   * @return massFields
   */
  public List getMassFields();

  /**
   * returns all fields available for the instance of the managed type at this
   * index of the internal list. Throws an <code>IndexOutOfBoundsException
   * </code> if no field set exists for the given index.
   *
   * @param index TBD: Description of the incoming method parameter
   * @return fieldSet
   */
  public FieldSet getFieldSet(int index);

}
