/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.controlstatus;

/**
 * encapsulates all information necessary to render an attribute for a service,
 * data object etc. and to update this information. An <code>IControlStatus
 * </code> holds a number of these instances and uses them to communicate with a
 * rendering framework
 */
public interface IField {

  /**
   * returns the identifier set when constructing the implementing class. This
   * identifier must be unique within one <code>IControlStatus</code> .
   *
   * @return identifier
   */
  public FieldIdentifier getIdentifier();

  /**
   * flag to tell, if the value of the implementing class can be updated
   *
   * @return readOnly
   */
  public boolean isReadOnly();

  /**
   * returns the current value defined for this field
   *
   * @return currentValue
   */
  public String getCurrentValue();

//  public String getInitialValue();

  /**
   * returns a localized message to render or an URL-style string that points to
   * a resource to load.
   *
   * @param info TBD: Description of the incoming method parameter
   * @return metaInfo
   */
  public String getMetaInfo(MetaInfo info);


  /**
   * allows to update the current value for this field. If the input does not
   * adhere to certain restrictions defined for this field, the input might not
   * be set.
   *
   * @param value currentValue to be set
   */
  public void setCurrentValue(String value);

  /**
   * returns the status information for this field. If e.g. an invalid value was
   * set, this method would return a detailed, localized message and the
   * severity of this error.
   *
   * @return statusInformation
   */
  public StatusInformation getStatusInformation();

}
