/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.controlstatus;

import com.sapportals.wcm.WcmException;
import java.util.List;
/**
 * @author Andreas Heix allows to store all data needed to fulfill a certain
 *      operation that might span over several request-cycles in the
 *      user-interface. At the end of such a user- interaction, the <code>
 *      execute</code> method might be used to actually write the information to
 *      the underlying service and repository framework and to retrieve the
 *      feedback from the framework.
 */
public interface IControlStatus {

  /**
   * carries out the action described by the given parameter.
   *
   * @param executable TBD: Description of the incoming method parameter
   * @return the status of the execution - can be null.
   * @exception WcmException Exception raised in failure situation
   */
  public StatusInformation execute(IExecutable executable)
    throws WcmException;

  /**
   * different signature for this method. The implementation must iterate
   * through its defined list of <code>IExecutable</code> objects. If the given
   * parameter matches the <code>IExecutable</code> 's <code>getIdentifier.getID
   * </code>, this <code>IExecutable</code> must be passed to the other
   * signature of this method.
   *
   * @param execution TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   * @exception WcmException Exception raised in failure situation
   * @throws WcmException, if no matching class could be found.
   */
  public StatusInformation execute(String execution)
    throws WcmException;

  /**
   * returns the field with the given ident-parameter or <code>null</code> , if
   * no such instance could be found.
   *
   * @param ident TBD: Description of the incoming method parameter
   * @return field
   */
  public IField getField(FieldIdentifier ident);

  /**
   * returns the <code>IExecutable</code> with the given ident-parameter or
   * <code>null</code> , if no such instance could be found.
   *
   * @param ident TBD: Description of the incoming method parameter
   * @return action
   */
  public IExecutable getAction(FieldIdentifier ident);

  /**
   * returns a list with all fields defined by the implementing class
   *
   * @return fields
   */
  public List getFields();

  /**
   * returns a list with all <code>IExecutable</code> s defined by the
   * implementing class
   *
   * @return actions
   */
  public List getActions();

  /**
   * returns the status of the implementing class. This status is obtained by
   * asking all of the fields of the implementing class for their status. The
   * first class, that returns a status != <code>null</code> will be used and
   * its status will be returned. Consequently, this method might return <code>
   * null</code>
   *
   * @return statusInformation
   */
  public StatusInformation getStatusInformation();

  /**
   * returns the ID under which this status was registered by the Service
   *
   * @return iD
   */
  public String getID();

  /**
   * sets the ID under which this status was registered by the service this
   * field is set by the service and must not be altered afterwards.
   *
   * @param id iD to be set
   */
  public void setID(String id);
}
