/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.controlstatus;
import com.sapportals.wcm.util.uuid.UUID;

import java.util.*;

/**
 * TBD: Description of the class.
 */
public class FieldSet {

  private HashMap fields = new HashMap();
  private boolean selected = false;
  private String ID = null;

  public FieldSet() {
    this.ID = new UUID().toString();
  }

  public FieldSet(String id) {
    this.ID = id;
  }

  public String getID() {
    return this.ID;
  }

  public void setSelected(boolean flag) {
    this.selected = flag;
  }

  public boolean isSelected() {
    return this.selected;
  }

  public int size() {
    return this.fields.size();
  }

  public IField putField(FieldIdentifier ident, IField field) {
    return (IField)this.fields.put(ident, field);
  }

  public IField getField(FieldIdentifier ident) {
    return (IField)this.fields.get(ident);
  }
}
