/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.controlstatus;

import com.sapportals.wcm.WcmException;
import java.util.*;

/**
 * TBD: Description of the class.
 */
public class Field implements IField {

  private FieldIdentifier id = null;
  private String currentvalue = null;
  private String initialvalue = null;
  private String label = null;
  private String tooltip = null;
  private boolean readonly = false;
  private ICondition condition = null;
  private boolean valid = true;
  private Locale locale = null;
  private HashMap metainfos = null;

  public Field(FieldIdentifier id, String currentvalue, HashMap metainfo, boolean readonly, ICondition condition, Locale locale) {
    this.id = id;
    this.currentvalue = currentvalue;
    this.initialvalue = currentvalue;
    this.label = label;
    this.tooltip = tooltip;
    this.readonly = readonly;
    this.condition = condition;
    this.locale = locale;
    this.metainfos = metainfo;
  }

  /**
   * shortened Constructor, which will set the following values for the dropped
   * parameters readonly will be set to <code>false</code> condition will be set
   * to <code>null</code>
   *
   * @param id TBD: Description of the incoming method parameter
   * @param currentvalue TBD: Description of the incoming method parameter
   * @param metainfo TBD: Description of the incoming method parameter
   * @param locale TBD: Description of the incoming method parameter
   */
  public Field(FieldIdentifier id, String currentvalue, HashMap metainfo, Locale locale) {
    this(id, currentvalue, metainfo, false, null, locale);
  }

  public FieldIdentifier getIdentifier() {
    return this.id;
  }

  public boolean isReadOnly() {
    return this.readonly;
  }

  public String getCurrentValue() {
    return this.currentvalue;
  }

  public String getInitialValue() {
    return this.initialvalue;
  }


  public String getMetaInfo(MetaInfo info) {
    if (this.metainfos != null) {
      return (String)this.metainfos.get(info);
    }
    return null;
  }


  public void setCurrentValue(String value) {
    if (this.condition != null) {
      this.valid = this.condition.isValid(value);
    }
    this.currentvalue = value;
  }

  public StatusInformation getStatusInformation() {
    if (!this.valid) {
      return new StatusInformation(Status.ERROR, this.getMetaInfo(MetaInfo.ERRORMESSAGE));
    }
    else {
      return null;
    }
  }
}
