/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.content;

import java.io.InputStream;

/**
 * Extended interface to content. <p>
 *
 * As an extension to {@link IContent}, this allows getting content-encoded
 * input streams. <p>
 *
 * EXPERIMENTAL <p>
 *
 * Copyright (c) SAP AG 2001-2004
 *
 * @author martin.boettcher@greenbytes.de
 * @version $Revision: 1.3 $
 */
public interface IExtendedContent {

  /**
   * Returns an input stream of the resource content that MAY be content-encoded
   * according to the requested encoding. {@link
   * IEncodedInputStream#getEncoding()} can be used to actually determine the
   * encoding of the input stream.
   *
   * @param requestedContentEncoding (case-insensitive) name of requested
   *      content encoding
   * @return The resource content as an InputStream that maybe an instance of
   * @exception ContentException
   */
  public InputStream getInputStream(String requestedContentEncoding)
    throws ContentException;

}
