/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: $
 */
package com.sapportals.wcm.util.config;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

import com.sapportals.config.fwk.IConfigurable;
import com.sapportals.portal.security.usermanagement.IServiceUserFactory;
import com.sapportals.portal.security.usermanagement.IUser;
import com.sapportals.portal.security.usermanagement.UserManagementException;
import com.sapportals.wcm.util.usermanagement.WPUMFactory;

public final class ConfigCrutch {

  private final static String CONFIG_SERVICE_USER = "index_service";
  
  public static IUser getConfigServiceUser() throws UserManagementException {
    IServiceUserFactory factory = WPUMFactory.getServiceUserFactory();
    return factory.getServiceUser(CONFIG_SERVICE_USER);
  }

  public static Properties getConfigurableProperties(IConfigurable configurable) {
    Map map = configurable.getProperties(true);
    Properties properties = new Properties();
    Iterator i = map.keySet().iterator();
    while (i.hasNext()) {
      Object key = i.next();
      Object value = map.get(key);
      if (value != null) {
        properties.setProperty(key.toString(), value.toString());
      }
    }
    return properties;
  }
  
}
