/**
 * Copyright (c) SAP AG 2001-2002
 * @author paul.goetz@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/50_SP6_COR/src/java/util/api/com/sapportals/wcm/util/channels/RecipientFactory.java#1 $
 */
package com.sapportals.wcm.util.channels;


import javax.mail.*;

import com.sapportals.wcm.WcmException;


/**
 * The <code>PartialSendException</code> indicates, that some recipients
 * couldn't be addressed.
 *
 * @see IChannel
 */
public class PartialSendException
extends WcmException {

  // ---------------
  // Private Members ----------------------------------------------------------
  // ---------------

  private SendFailedException e;


  // ------------
  // Constructors -------------------------------------------------------------
  // ------------

  /**
   * Create a PartialSendException from a
   * <code>javax.mail.SendFailedException</code>.
   */
  public PartialSendException(SendFailedException e) {
    super(e);
    this.e = e;
  }


  // --------------
  // Public Methods -----------------------------------------------------------
  // --------------

  /**
   * Return the addresses to which the message was sent succesfully.
   * @return Addresses to which the message was sent successfully or
   *    <code>null</code>
   */
  public Address[] getValidSentAddresses() {
    return this.e.getValidSentAddresses();
  }


  /**
   * Return the addresses that are valid, but to which the message
   * was not sent.
   * @return Addresses that are valid but to which the message was not
   *    sent successfully or <code>null</code>
   */
  public Address[] getValidUnsentAddresses() {
    return this.e.getValidUnsentAddresses();
  }


  /**
   * Return the addresses to which the message could not be sent.
   * @return Addresses to which the message sending failed or
   *    <code>null</code>
   */
  public Address[] getInvalidAddresses() {
    return this.e.getInvalidAddresses();
  }


}
