/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.channels;

/**
 * Iterator for a <code>IRecipientList</code> . <br>
 *
 *
 * @see IRecipientList
 */
public interface IRecipientListIterator {

  public boolean hasNext();


  public IRecipient next();


  public boolean hasPrevious();


  public IRecipient previous();


  public int nextIndex();


  public int previousIndex();


  public void remove();


  public void set(IRecipient recipient);


  public void add(IRecipient recipient);

}
