/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.channels;

import java.util.Comparator;

/**
 * A list of <code>IRecipient</code> s. <br>
 *
 *
 * @see IRecipient
 */
public interface IRecipientList {

  public int size();


  public boolean contains(IRecipient recipient);


  public boolean add(IRecipient recipient);


  public boolean remove(IRecipient recipient);


  public IRecipient get(int index);


  public IRecipient set(int index,
    IRecipient recipient);


  public void add(int index,
    IRecipient recipient);


  public void addLast(IRecipient recipient);


  public IRecipient remove(int index);


  public int indexOf(IRecipient recipient);


  public int lastIndexOf(IRecipient recipient);


  public IRecipientListIterator listIterator();


  public IRecipientListIterator listIterator(int index);


  public IRecipientList subList(int startIndex,
    int stopIndex);


  public void sort(Comparator comparator);


  public IRecipientList expand()
    throws com.sapportals.wcm.WcmException;

}
