/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.channels;

import java.util.Comparator;

/**
 * A list of <code>IChannel</code> s. <br>
 *
 *
 * @see IChannel
 */
public interface IChannelList {

  public int size();


  public boolean contains(IChannel channel);


  public boolean add(IChannel channel);


  public boolean remove(IChannel channel);

  public boolean isEmpty();


  public IChannel get(int index);


  public IChannel set(int index,
    IChannel channel);


  public void add(int index,
    IChannel channel);


  public void addLast(IChannel channel);


  public IChannel remove(int index);


  public int indexOf(IChannel channel);


  public int lastIndexOf(IChannel channel);


  public IChannelListIterator listIterator();


  public IChannelListIterator listIterator(int index);


  public IChannelList subList(int startIndex,
    int stopIndex);


  public void sort(Comparator comparator);

}
