/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.cache;

/**
 * Provides basic statistical information about a cache instance.
 */
public interface ICacheStatistics {
  /**
   * @return get numbers of entries in the cache
   */
  public long getEntryCount();

  /**
   * @return the number of addEntry operations
   */
  public long getAddCount();

  /**
   * @return the number of addEntry operations which insert a new entry
   */
  public long getInsertCount();

  /**
   * @return the number of remove operations
   */
  public long getRemoveCount();

  /**
   * @return the number of get attempts
   */
  public long getGetCount();

  /**
   * @return the number of successful get attempts
   */
  public long getHitCount();

  /**
   * get historic maximum entry count
   *
   * @return maximumEntryCount
   */
  public long getMaximumEntryCount();

  /**
   * reset all counters
   */
  public void resetCounters();
}
