/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.cache;

import java.util.List;

/**
 * Keeps information about dependencies between cache entries. <p>
 *
 * When objects implementing this interface are inserted in an {@link ICache},
 * the dependency information is used to remove dependant cache entries on call
 * of any removeEntry method. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Id: ICacheNode.java,v 1.1 2002/09/24 10:48:48 sei Exp $
 */
public interface ICacheNode {

  /**
   * Get list of keys which, when removed, remove also this node.
   *
   * @return {@link java.util.List} of {@link java.lang.String}s.
   */
  List getMasterKeys();

  /**
   * Get list of keys which are removed, when this node is removed.
   *
   * @return {@link java.util.List} of {@link java.lang.String}s.
   */
  List getSlaveKeys();

  /**
   * Get the identity of the node, or <code>null</code> if not defined. On
   * removal of a node with identity, all nodes with the same identity are
   * removed as well.
   *
   * @return node identity or <code>null</code> if not defined.
   */
  String getIdentity();
}
