/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.cache;

/**
 * Represents a cache entry.
 */
public interface ICacheEntry {
  /**
   * @return key of the cache entry
   */
  public String getKey();

  /**
   * @return object of the cache entry
   */
  public Object getObject();

  /**
   * @return the size of the cache entry
   */
  public long getSize();

  /**
   * @return entries time to live in seconds
   */
  public long getTimeToLive();

  /**
   * @return absolute expiration time of the cache entry (0: never expires)
   *      (Date.getTime() compatible)
   */
  public long getExpirationTime();

  /**
   * @return date of last modification (Date.getTime() compatible)
   */
  public long getModificationTime();

  /**
   * @return true iff the cache entry is expired
   */
  public boolean isExpired();

  /**
   * @return true iff expiration is automatically delayed on access for the
   *      'time to live' value
   */
  public boolean isAutoDelaying();
}
