/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.cache;

import java.util.*;

/**
 * An iterator to access elements in a cache entry list.
 */
public class CacheEntryListIterator {
  private Iterator m_iterator = null;

  /**
   * constuct
   *
   * @param iterator TBD: Description of the incoming method parameter
   */
  public CacheEntryListIterator(Iterator iterator) {
    if (iterator == null) {
      throw new NullPointerException();
    }

    m_iterator = iterator;
  }

  /**
   * @return true iff the list holds more elements
   */
  public boolean hasNext() {
    return m_iterator.hasNext();
  }

  /**
   * @return the next element of the list
   */
  public ICacheEntry next() {
    return (ICacheEntry)m_iterator.next();
  }
}
