/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.cache;

import java.util.*;

/**
 * Represents a list of cache entries.
 */
public class CacheEntryList {
  private List m_list = null;

  /**
   * construct
   */
  public CacheEntryList() {
    m_list = new LinkedList();
  }

  /**
   * add an entry to the list
   *
   * @param entry entry to add
   */
  public void add(ICacheEntry entry) {
    if (entry == null) {
      throw new NullPointerException();
    }

    m_list.add(entry);
  }

  /**
   * @return iterator for this list
   */
  public CacheEntryListIterator iterator() {
    return new CacheEntryListIterator(m_list.iterator());
  }
}
