/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.acl;


import java.util.*;

import com.sapportals.portal.security.usermanagement.*;
import com.sapportals.wcm.WcmException;


/**
 * special implementation for a non existing user, tagged by
 * <code>IUMPrincipalRaw</code>. <br>
 *
 */
public final class UMPrincipalRaw
implements IUMPrincipal {

  private static final String EMPTY_STRING = "";
  private static final String[] EMPTY_STRINGARRAY = new String[] { EMPTY_STRING };

  private final int type;
  private final String typename;
  private final String id;
  
  public UMPrincipalRaw(int type,
                        String id)
                 throws WcmException {

    if( id == null ) throw new WcmException("invalid principal id <null>"); 
    switch( type ) {
      case IUMPrincipal.IGROUP: this.typename = "group:" + id; break;
      case IUMPrincipal.IROLE:  this.typename = "role:" + id;  break;
      case IUMPrincipal.IUSER:  this.typename = "user:" + id;  break;
      default: throw new WcmException("unknown principal type " + type);
    }
    this.type = type;
    this.id = id;
  }
  
  public String getDefaultRole() {
    return EMPTY_STRING;
  }

  public String[] getRoles() {
    return EMPTY_STRINGARRAY;
  }

  public String[] getDirectRoles() {
    return EMPTY_STRINGARRAY;
  }

  public String[] getRoleAttributes(String s) {
    return EMPTY_STRINGARRAY;
  }

  public String[] getValuesForRoleAttribute(String s, String s1) {
    return EMPTY_STRINGARRAY;
  }

  public String[] getGroups() {
    return EMPTY_STRINGARRAY;    
  }

  public String[] getValuesForKey(String s)
                           throws UserManagementException {
    return EMPTY_STRINGARRAY;
  }

  public String[] getKeys() {
    return EMPTY_STRINGARRAY;
  }

  public void refresh()
               throws UserManagementException {
  }

  public boolean isInGroup(String s) {
    return false;
  }

  public boolean isGroup() {
    return this.type == IUMPrincipal.IGROUP;
  }

  public int getType() {
    return this.type;
  }

  public String getId() {
    return this.id;
  }

  public boolean equals(IUMPrincipal principal) {
    if( principal == null) return false;
    if( this.id == null) return ( principal.getId() == null );
    if( this.type != principal.getType() ) return false;
    return this.id.equalsIgnoreCase(principal.getId());
  }

  public String[] getAllParentGroups() {
    return EMPTY_STRINGARRAY;    
  }

  public String[] getDirectParentGroups() {
    return EMPTY_STRINGARRAY;
  }

  public HashMap getRawUserMappingData(String s) {
    return new HashMap();
  }

  public String getDescription() {
    return this.typename + this.id;
  }

  public String getDisplayName() {
    return this.id;
  }

  public String getDisplayId() {
    return this.id;
  }

  public String getUMEId() {
    return this.id;
  }

  public int hashCode() {
    return this.typename.hashCode();
  }

  public boolean equals(Object obj) {
    if( obj == null) return false;
    if( obj instanceof IUMPrincipal ) {
      IUMPrincipal principal = (IUMPrincipal)obj;
      if( this.id == null) return ( principal.getId() == null );
      if( this.type != principal.getType() ) return false;
      return this.id.equalsIgnoreCase(principal.getId());
    } else {
      return false;
    }
  }
  
}
