/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.acl;

import com.sapportals.portal.security.usermanagement.*;

import java.util.*;

/**
 * Default implementation of an <code>UMPrincipalListIterator</code> , an
 * iterator for <code>IUMPrincipalList</code> s. <br>
 *
 */
public final class UMPrincipalListIterator implements IUMPrincipalListIterator {
  private Iterator m_iterator = null;


  public UMPrincipalListIterator(Iterator iterator) {
    m_iterator = iterator;
  }

  public boolean hasNext() {
    return m_iterator.hasNext();
  }

  public IUMPrincipal next() {
    return (IUMPrincipal)m_iterator.next();
  }
}
