/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.acl;

import com.sapportals.portal.security.usermanagement.*;

import java.util.*;

/**
 * Default implementation of an <code>IUMPrincipalList</code> , a list of <code>
 * IUMPrincipal</code> s. <br>
 *
 */
public final class UMPrincipalList implements IUMPrincipalList {
  private List m_list = null;
  private boolean m_containsRaw = false;

  public UMPrincipalList() {
    m_list = new LinkedList();
    m_containsRaw = false;
  }

  public void add(IUMPrincipal principal) {
    m_list.add(principal);
    if(   ( m_containsRaw == false )
       && ( principal instanceof IUMPrincipalRaw )
      ) {
      m_containsRaw = true; 
    }
  }

  public boolean containsRawEntries() {
    return m_containsRaw;
  }
  
  public IUMPrincipalListIterator iterator() {
    return new UMPrincipalListIterator(m_list.iterator());
  }
}
