/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.acl;

/**
 * The default implementation for <code>IObjectType</code> s, the type of an
 * object associated to an <code>IAcl</code> . <br>
 *
 */
public final class ObjectType implements IObjectType {

  public final static IObjectType LEAF = new ObjectType(IObjectType.OBJECT_TYPE_LEAF);
  public final static IObjectType NODE = new ObjectType(IObjectType.OBJECT_TYPE_NODE);

  private final String name;

  public ObjectType(String name) {
    if (name == null) {
      throw new NullPointerException();
    }
    this.name = name;
  }

  public String getName() {
    return this.name;
  }

  public boolean equals(IObjectType objectType) {
    return this.name.equals(objectType.getName());
  }


  public boolean equals(Object other) {
    if (other instanceof IObjectType) {
      return equals((IObjectType)other);
    }
    return false;
  }

  public int hashCode() {
    return this.name.hashCode();
  }
}
