/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.util/60NW_SP_COR/src/_public/java/api/com/sapportals/wcm/util/acl/IAclRaw.java#1 $
 */

package com.sapportals.wcm.util.acl;


import java.util.*;

import com.sapportals.portal.security.usermanagement.*;


/**
 * A <code>IAclRaw</code> is a <code>IAcl</code> which also supports the
 * retrieval of deleted owners and ACEs for deleted principals. <br>
 */
public interface IAclRaw
extends IAcl {

  /**
   * Get a list of the owners of the ACL.
   * The returned list might also contain entries for principals which are
   * already deleted in the usermanagement.
   * @return the list of the owners for the ACL, some of them might be
   *        <code>IUMPrincipalRaw</code>s
   * @exception AclPersistenceException indicates a problem with the storage
   */
  public IUMPrincipalList getOwnersRaw()
                                throws AclPersistenceException;


  /**
   * Get the ACEs of the ACL.
   * The returned list might also contain entries for principals which are
   * already deleted in the usermanagement.
   * @return the list of ACEs, some of them might be
   *        <code>IAclEntryRaw</code>s
   * @exception AclPersistenceException indicates a problem with the storage
   */
  public IAclEntryList getEntriesRaw()
                              throws AclPersistenceException;


}
