/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.util/60NW_SP_COR/src/_public/java/api/com/sapportals/wcm/util/acl/IAclManagerRaw.java#1 $
 */

package com.sapportals.wcm.util.acl;


import java.util.*;

import com.sapportals.portal.security.usermanagement.*;
import com.sapportals.wcm.util.cache.*;


/**
 * A <code>IAclManagerRaw</code> extends a <code>IAclManager</code> by
 * methods to access even those ACLs with either deleted owners or
 * deleted principals in the ACL's ACEs. <br> 
 */
public interface IAclManagerRaw
extends IAclManager {

  /**
   * Get a specific ACL, which might be a <code>IAclRaw</code>.
   * @param aclID ID of the ACL
   * @param contextDBVersion expected version of the ACL in cache (used to
   *        check if the cache has become invalid)
   * @return the ACL with the given ID or <code>null</code> if not existent
   * @exception AclPersistenceException indicates a problem with the storage
   */
  public IAcl getAclRaw(String aclID,
                        long contextDBVersion)
                 throws AclPersistenceException;

  
  /**
   * Get several ACLs, some of them might be <code>IAclRaw</code>s or
   * <code>null</code>.
   * @param aclIDs an array of <code>String</code>s with the IDs of the
   *        ACLs
   * @return an array of ACLs (might be <code>IAclRaw</code>s or
   *        <code>null</code>)
   * @exception AclPersistenceException indicates a problem with the storage
   */
  public IAcl[] getAclsRaw(String aclIDs[])
                    throws AclPersistenceException;


}
