/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.acl;

import java.util.*;

/**
 * Default implementation of an <code>IAclPermissionList</code> , a list of
 * <code>IAclPermission</code> s. <br>
 *
 */
public final class AclPermissionList implements IAclPermissionList {

  private final List list;

  public AclPermissionList() {
    this.list = new ArrayList(17);
  }

  public boolean add(IAclPermission permission) {
    return this.list.add(permission);
  }

  public IAclPermissionListIterator iterator() {
    return new AclPermissionListIterator(this.list.iterator());
  }

  public int size() {
    return this.list.size();
  }

  public int hashCode() {
    return this.list.hashCode();
  }

  public boolean equals(Object obj) {
    if (obj instanceof AclPermissionList) {
      AclPermissionList other = (AclPermissionList)obj;
      return this.list.equals(other.list);
    }
    return false;
  }

  public String toString() {
    StringBuffer sb = new StringBuffer(64);
    sb.append("AclPermissionList[").append(this.list.toString()).append("]");
    return sb.toString();
  }
}

